/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTabButton;
import jclass.bwt.JCTabManager;
import jclass.bwt.Shadow;

public class TabPageArea
extends JCContainer {
    CardLayout card;
    JCTabManager tab_manager;
    Component page;
    private static final String base = "tabpagearea";
    private static int nameCounter;

    public TabPageArea(JCTabManager jCTabManager) {
        this.setName(base + nameCounter++);
        this.tab_manager = jCTabManager;
        this.card = new CardLayout();
        this.setLayout(this.card);
        this.setInsets(new Insets(1, 1, 1, 1));
    }

    protected void addPage(Component component) {
        if (component != null && component.getParent() != this) {
            this.add(String.valueOf(component.hashCode()), component);
        }
    }

    protected void showPage(Component component) {
        if (component != null) {
            ((CardLayout)this.getLayout()).show(this, String.valueOf(component.hashCode()));
        }
        this.page = component;
        if (this.isShowing()) {
            this.drawShadow(this.getGraphics());
        }
    }

    public synchronized void paintInterior(Graphics graphics) {
        this.drawShadow(graphics);
    }

    protected void drawShadow(Graphics graphics) {
        Color color;
        Color color2 = color = this.page != null ? this.page.getBackground() : this.getBackground();
        if (color == null) {
            return;
        }
        Shadow.draw(graphics, 4, 1, 0, 0, this.size().width, this.size().height, color, null);
        JCTabButton jCTabButton = this.tab_manager.getTab(this.tab_manager.getCurrentTab());
        if (jCTabButton == null) {
            return;
        }
        int n = jCTabButton.highlight + jCTabButton.shadow;
        int n2 = jCTabButton.location().x + n;
        int n3 = 0;
        int n4 = n2 + jCTabButton.size().width - 2 * n;
        switch (this.tab_manager.getTabSide()) {
            case 1: {
                n3 = 0;
                break;
            }
            case 5: {
                n3 = this.size().height - 1;
                break;
            }
        }
        graphics.setColor(color);
        graphics.drawLine(n2, n3, n4, n3);
        graphics.setColor(Color.black);
        graphics.drawLine(n4 + 1, n3, n4 + 1, n3);
    }
}

